﻿using System;
using System.Linq;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Text;
using System.Windows.Forms;

using Microsoft.WindowsMobile.PocketOutlook;
using Microsoft.WindowsMobile.Telephony;

namespace Kontakty
{
    public partial class Form1 : Form
    {
        OutlookSession outlook = new OutlookSession();
        Phone telefon = new Phone();

        public Form1()
        {
            InitializeComponent();

            dataGrid1.DataSource = outlook.Contacts.Items;                                    
        }

        private void menuItem2_Click(object sender, EventArgs e)
        {
            Contact kontakt = outlook.Contacts.Items.AddNew();
            kontakt.FirstName = "Jan";
            kontakt.LastName = "Kowalski";
            kontakt.MobileTelephoneNumber = "7272024";
            kontakt.Email1Address = "jankow@afero.pl";
            kontakt.BusinessTelephoneNumber = "7272020";
            kontakt.Update();

            kontakt = outlook.Contacts.Items.AddNew();
            kontakt.FirstName = "Bartosz";
            kontakt.LastName = "Turowski";
            kontakt.Email1Address = "tubartek@gmail.com";
            kontakt.BusinessTelephoneNumber = "7272022";
            kontakt.Update();

            kontakt = outlook.Contacts.Items.AddNew();
            kontakt.FirstName = "Jacek";
            kontakt.LastName = "Matulewski";
            kontakt.Email1Address = "jacek@fizyka.umk.pl";
            kontakt.MobileTelephoneNumber = "7272021";
            kontakt.Update();

            dataGrid1.Refresh();
        }

        private void menuItem3_Click(object sender, EventArgs e)
        {                        
            Contact kontakt = new Contact();
            string orgFileAs = kontakt.FileAs;
            kontakt.ShowDialog();
            if (kontakt.FileAs != orgFileAs)
                outlook.Contacts.Items.Add(kontakt);
        }

        private void menuItem5_Click(object sender, EventArgs e)
        {
            Contact kontakt=outlook.Contacts.Items[dataGrid1.CurrentCell.RowNumber];
            string numerTelefonu = kontakt.MobileTelephoneNumber;
            if (numerTelefonu == "") numerTelefonu = kontakt.BusinessTelephoneNumber;
            if (numerTelefonu != "") new Phone().Talk(numerTelefonu);
            else MessageBox.Show("Wybrany kontakt nie zawiera numeru telefonu komórkowego ani służbowego");
        }

        static string katalogAplikacji
        {
            get
            {
                string katalog = System.IO.Path.GetDirectoryName(System.Reflection.Assembly.GetExecutingAssembly().GetName().CodeBase);
                if (katalog.StartsWith("file:")) katalog = katalog.Remove(0, 6);
                return katalog;
            }
        }

        private void menuItem6_Click(object sender, EventArgs e)
        {
            Contact kontakt=outlook.Contacts.Items[dataGrid1.CurrentCell.RowNumber];
            string numerTelefonu = kontakt.MobileTelephoneNumber;
            if (numerTelefonu!="")
            {
                string sciezkaDoPliku = System.IO.Path.Combine(katalogAplikacji, "SMS.exe");
                System.Diagnostics.ProcessStartInfo psi = new System.Diagnostics.ProcessStartInfo(sciezkaDoPliku, numerTelefonu);
                System.Diagnostics.Process.Start(psi);
            }
            else MessageBox.Show("Wybrany kontakt nie zawiera numeru telefonu komórkowego");
        }

        private void menuItem7_Click(object sender, EventArgs e)
        {
            Contact kontakt = outlook.Contacts.Items[dataGrid1.CurrentCell.RowNumber];
            string adresEmail = kontakt.Email1Address;
            if (adresEmail == "") adresEmail = kontakt.Email2Address;
            if (adresEmail == "") adresEmail = kontakt.Email3Address;
            if (adresEmail != "")
            {
                string sciezkaDoPliku = System.IO.Path.Combine(katalogAplikacji, "Email.exe");
                System.Diagnostics.ProcessStartInfo psi = new System.Diagnostics.ProcessStartInfo(sciezkaDoPliku, adresEmail);
                System.Diagnostics.Process.Start(psi);
            }
            else MessageBox.Show("Wybrany kontakt nie zawiera adresu poczty elektronicznej");
        }
    }
}